<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// email_sender.php

// Only process POST requests
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    
    // Sanitize and validate inputs
    $to = filter_var($_POST['to'], FILTER_VALIDATE_EMAIL);
    $subject = htmlspecialchars($_POST['subject'] ?? '');
    $bodyContent = $_POST['body'] ?? '';
    $from = filter_var($_POST['from'], FILTER_VALIDATE_EMAIL);

    if (!$to || !$from || empty($subject) || empty($bodyContent)) {
        echo json_encode([
            'status' => 'error',
            'message' => 'All fields are required and must be valid.'
        ]);
        exit;
    }

    // Email headers
    $headers = "From: {$from}\r\n";
    $headers .= "Reply-To: {$from}\r\n";
    $headers .= "MIME-Version: 1.0\r\n";
    $headers .= "Content-Type: text/html; charset=UTF-8\r\n";

    // Optional: Use Bootstrap 5 for styling
    $body = '
    <!DOCTYPE html>
    <html lang="en">
    <head>
        <meta charset="UTF-8">
        <title>' . htmlspecialchars($subject) . '</title>
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    </head>
    <body>
        <div class="container py-4">
            <div class="card border-primary">
                <div class="card-header bg-primary text-white">
                    ' . htmlspecialchars($subject) . '
                </div>
                <div class="card-body">
                    ' . $bodyContent . '
                </div>
            </div>
        </div>
    </body>
    </html>
    ';

    // Send email
    if (mail($to, $subject, $body, $headers)) {
        echo json_encode([
            'status' => 'success',
            'message' => 'Email sent successfully to ' . $to
        ]);
    } else {
        echo json_encode([
            'status' => 'error',
            'message' => 'Failed to send email.'
        ]);
    }
} else {
    echo json_encode([
        'status' => 'error',
        'message' => 'Invalid request method.'
    ]);
}
